<?php
//
// Rcupration du catalogue produit
// PARAM Obligatoires:
// idMag: code du magasin  utiliser.
//
// PARAM Optionnels:
// idArt: premier code article  rechercher
// idCrit: critre  utiliser
// idFourn: fournisseur
// idMod: modle  utiliser
//

include ('../config.php');

if (isset($_GET['idMag']))
{
    $idMag = (int) $_GET['idMag'];

	if (isset($_GET['idArt']))
		$idArt = (int) $_GET['idArt'];
	else
		$idArt = 1;
		
		/*
	 * connect
	 */
	$conn = mssql_connect(__SRV__, __USER__, __PASS__);
	if ($conn === false) {
		sendResponse(503, "Unable to connect");
		die();
	}
	mssql_select_db(__DBNAME__, $conn);

	/*
	 * query
	 */
	$query = "SELECT Article.id, SousCategorie.nom AS scat, Categorie.nom AS cat, Model.nom AS nomMod, Model.id as idMod, Model.observations AS obs, couleur.nom AS couleur, Taille.nom AS taille, Longueur.nom AS longueur, StockMag.quantite AS qtt, StockMag.prixVente as PV, Article.codeB_EAN as EAN, model.imageFile, FournMag.raison_sociale
				FROM StockMag INNER JOIN
							 Article ON StockMag.idArt = Article.id INNER JOIN
							 Model ON Article.idMod = Model.id INNER JOIN
							 SousCategorie ON Model.idSCat = SousCategorie.id INNER JOIN
							 Categorie ON SousCategorie.idCat = Categorie.id INNER JOIN
							 FournMag ON Model.idFourn = FournMag.id INNER JOIN
							 couleur ON Article.idCoul = couleur.id INNER JOIN
							 Taille ON Article.idTail = Taille.id LEFT OUTER JOIN
							 Taille AS Longueur ON Article.idLong = Longueur.id
				WHERE Model.visible = 1 AND Article.visible = 1 AND StockMag.idMag = $idMag AND StockMag.idArt >= $idArt ";

	if (isset($_GET['idFourn']))
		$query .= "AND Model.idFourn = " . $_GET['idFourn'] . " ";

	if (isset($_GET['idMod']))
		$query .= "AND Model.id = " . $_GET['idMod'] . " ";

	if (isset($_GET['idCrit']))
		$query .= "AND Model.id IN (select idMod from mod_crit where idCrit = " .$_GET['idCrit'] . ") ";

	$query .= " ORDER BY Article.id";

	$result = mssql_query($query, $conn);
	if ($result == false)
		sendResponseAndDie(400, 'Query error');

	if (! mssql_num_rows($result))
		sendResponse(400, 'No result');
	else 
	{
    	if ($format == 'json')
		{
			/*
			* output in json
			*/
			while ( $row = mssql_fetch_array ( $result, MSSQL_ASSOC ) )
			{
				$artList [] = array (
						'idArt' => ( int ) $row ['id'],
						'scat' => ( string ) $row ['scat'],
						'cat' => ( string ) $row ['cat'],
						'model' => ( string ) $row ['nomMod'],
						'fournisseur' => ( string ) $row ['raison_sociale'],
						'obs' => ( string ) $row ['obs'],
						'couleur' => ( string ) $row ['couleur'],
						'taille' => ( string ) $row ['taille'],
						'longueur' => ( string ) $row ['longueur'],
						'qtt' => ( int ) $row ['qtt'], 
						'pv' => ( double ) $row ['PV'],
						'EAN' => ( string ) $row ['EAN'],
						'imageFile' => ( string ) $row ['imageFile']);
			};

			sendResponse(200, json_encode($artList), 'application/json');
			
			/* exemple de sortie json:
			//   [{"idArt":18763,"scat":"PULL","cat":"PULL","model":"E7K0150SD704","fournisseur":"SINEQUANONE","obs":" ","couleur":"REGLISSE","taille":"1","longueur":"","qtt":0,"pv":49.9,"EAN":"5555500187638","imageFile":""},
			//    {"idArt":18764,"scat":"PULL","cat":"PULL","model":"E7K0150SD704","fournisseur":"SINEQUANONE","obs":" ","couleur":"REGLISSE","taille":"2","longueur":"","qtt":0,"pv":49.9,"EAN":"5555500187645","imageFile":""}]
			*/
		}
        else
        {
			/*
			 * output in XML
			 */
			$output = '<?xml version="1.0" encoding="ISO-8859-1"?>';
			$output .= '<articles>';
			while ($row = mssql_fetch_array($result, MSSQL_ASSOC))
			{
				
					$output .= '<art id="' . $row['id'] . '">';
					$output .= "<scat>" . $row['scat'] . "</scat>";
					$output .= "<cat>" . $row['cat'] . "</cat>";
					$output .= "<model>" . $row['nomMod'] . "</model>";
					$output .= '<fournisseur>' . $row['raison_sociale'] . '</fournisseur>';
					$output .= "<obs>" . $row['obs'] . "</obs>";
					$output .= "<couleur>" . $row['couleur'] . "</couleur>";
					$output .= "<taille>" . $row['taille'] . "</taille>";
					if ($row['longueur'] != '') {
						$output .= "<longueur>" . $row['longueur'] . "</longueur>";
					}
					$output .= "<qtt>" . $row['qtt'] . "</qtt>";
					$output .= "<pv>" . $row['PV'] . "</pv>";
					$output .= "<EAN>" . $row['EAN'] . "</EAN>";
					$output .= '<image>' . $row['imageFile'] . '</image>';
					$output .= "<modelId>" . $row['idMod'] . "</modelId>";
					$output .= "</art>";
			}
			$output .= '</articles>';
			sendResponse(200, $output);
			
			// EXEMPLE DE SORTIE XML
			// <articles>
			// <art id="1" idMag="2">
			// <qtt>90</qtt>
			// <pv>119.8</pv>
			// </art>
			// <art id="1" idMag="3">
			// <qtt>10</qtt>
			// <pv>119.8</pv>
			// </art>
			// <art id="2" idMag="2">
			// <qtt>90</qtt>
			// <pv>119.8</pv>
			// </art>
			// <art id="2" idMag="3">
			// <qtt>10</qtt>
			// <pv>119.8</pv>
			// </art>
			// </articles>
		}
	}

	mssql_free_result($result);
}
else
{
	sendResponse ( 400, 'Invalid request' );
}

?>